/*  -*- pse-c -*-
 *----------------------------------------------------------------------------
 * Filename: iegd_interface.c
 * $Revision: 1.1.2.5 $
 *----------------------------------------------------------------------------
 * <>
 * Copyright © 2006, Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU General Public License,
 * version 2, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 
 * 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 *
 *
 *----------------------------------------------------------------------------
 * Functions:
 *
 *
 *----------------------------------------------------------------------------
 */

#ifndef _KERNEL_ABS_LAYER
#define _KERNEL_ABS_LAYER

#include <linux/version.h>

#if LINUX_VERSION_CODE >= KERNEL_VERSION(2,6,21)
#define IGD_FREE_MEM(a) agp_free_page_array(a)
#else
#define IGD_FREE_MEM(a) vfree((a)->memory)
#endif

#if LINUX_VERSION_CODE == KERNEL_VERSION(2,6,5)
#define DRM_INIT_MODULE() drm_init()
#define DRM_EXIT_MODULE() drm_cleanup()
#define AGP_RET(a) ((a)>=0) ? 1 : 0
#else
#define DRM_INIT_MODULE() intel_init()
#define DRM_EXIT_MODULE() intel_exit()
#define AGP_RET(a) ((a)==0) ? 1 : 0
#endif

#define MASK_PTE(a,b) (a)->driver->masks[(b)].mask
#define AGP_MASK_ADDR(x) MASK_PTE((x),type)

/*
 * Kernel interface abstraction. This macro will
 * point to the proper definition for that particular
 * kernel
 */
#define AGP_MASK_MEMORY(f)   _MASK_MEMORY(f)
#define AGP_CREATE_GATT(f)   _CREATE_GATT_TABLE(f)
#define AGP_FREE_GATT(f)     _FREE_GATT_TABLE(f)
#define AGP_ALLOC_PAGE(f)    _ALLOC_PAGE_AGP(f)
#define AGP_ENABLE(f)        _ENABLE_AGP(f)
#define AGP_TYPE_TO_MASK_TYPE(f) _TYPE_TO_MASK_TYPE(f)

#define AGP_MASK_GTT()   _mask_gtt()
#endif
